attribute highp vec4	myVertex;
attribute mediump vec4	myUV;

uniform highp vec4 fogColor;
uniform highp float fogMaxDist;
uniform highp float fogMinDist;

uniform mediump mat4	MVMatrix;
uniform mediump mat4	PMVMatrix;

varying mediump vec2	varCoord;
varying highp float fogFactor;

void main(void)
{
	highp vec4 viewPosition = MVMatrix * myVertex;
    gl_Position = PMVMatrix * myVertex;

	//Compute fog
	fogFactor = (fogMaxDist - viewPosition.z) / (fogMaxDist - fogMinDist);
	fogFactor = clamp(fogFactor, 0.0, 1.0);

    varCoord = myUV.st;
}